<?xml version="1.0" encoding="UTF-8"?>
<md:node xmlns:md="http://www.stambia.com/md" defType="com.stambia.http.rest" id="_INPhYL9aEeqccNI2vvuvYA" name="HTTP REST API" md:ref="resource.tech#UUID_TECH_HTTPREST?fileId=UUID_TECH_HTTPREST$type=tech$name=HttpRest?" internalVersion="v2.0.0">
  <attribute defType="com.stambia.http.rest.module" id="_INPhYb9aEeqccNI2vvuvYA" value="HttpRest"/>
  <attribute defType="com.stambia.http.rest.url" id="_INPhYr9aEeqccNI2vvuvYA" value="http://hostname:8080/endpoint/base/url/"/>
  <attribute defType="com.stambia.http.rest.security" id="_oemI4L9aEeqccNI2vvuvYA" ref="resource.md#_INRX479aEeqccNI2vvuvYA?fileId=_INRX4r9aEeqccNI2vvuvYA$type=md$name=User%20Credentials?"/>
  <node defType="com.stambia.http.rest.path" id="_INPhZb9aEeqccNI2vvuvYA">
    <attribute defType="com.stambia.http.rest.path.path" id="_INPhZr9aEeqccNI2vvuvYA" value="examples/A"/>
    <attribute defType="com.stambia.http.rest.path.summary" id="_INPhZ79aEeqccNI2vvuvYA" value="First set of examples"/>
    <attribute defType="com.stambia.http.rest.path.description" id="_4Ru1AL9bEeqccNI2vvuvYA" value="This path corresponds to a resource called examples/A in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated to the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A"/>
    <node defType="com.stambia.http.rest.path" id="_INPhaL9aEeqccNI2vvuvYA" name="BINARY - binary as input and output" position="1">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPhab9aEeqccNI2vvuvYA" value="binary"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPhar9aEeqccNI2vvuvYA" value="Binary file as input and output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_GCNiUL9cEeqccNI2vvuvYA" value="This path corresponds to a resource called 'binary' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/binary&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to handle binary content as input and output"/>
      <node defType="com.stambia.http.rest.operation" id="_INPha79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPhbL9aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_QHfJML9cEeqccNI2vvuvYA" value="Send and retrieve a binary file"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_TETfoL9cEeqccNI2vvuvYA" value="This operation will send a POST request with defined Parameters and Request Body.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the reponse through the responses defined under 'Responses' node."/>
        <node defType="com.stambia.http.rest.requestbody" id="_INPhbb9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INPhbr9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INPhb79aEeqccNI2vvuvYA" value="BINARY"/>
            <attribute defType="com.stambia.http.rest.content.contentType" id="_INPhcL9aEeqccNI2vvuvYA" value="image/png"/>
          </node>
        </node>
        <node defType="com.stambia.http.rest.parameters" id="_BNHnIHVyEe2HPbm_OA_ttA">
          <node defType="com.stambia.http.rest.parameter" id="_XEe9f2l8Ee2Ub5oQ2PlTWg" name="newParamc">
            <attribute defType="com.stambia.http.rest.parameter.allowEmptyValue" id="_XEe9gGl8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9gWl8Ee2Ub5oQ2PlTWg" value="query"/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_XEe9hWl8Ee2Ub5oQ2PlTWg" name="newParamg">
            <attribute defType="com.stambia.http.rest.parameter.allowEmptyValue" id="_XEe9hml8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9h2l8Ee2Ub5oQ2PlTWg" value="query"/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_XEe9fGl8Ee2Ub5oQ2PlTWg" name="newParams">
            <attribute defType="com.stambia.http.rest.parameter.allowEmptyValue" id="_XEe9fWl8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9fml8Ee2Ub5oQ2PlTWg" value="query"/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_XEe9gml8Ee2Ub5oQ2PlTWg" name="newParamz">
            <attribute defType="com.stambia.http.rest.parameter.allowEmptyValue" id="_XEe9g2l8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9hGl8Ee2Ub5oQ2PlTWg" value="query"/>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_MADTUnV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe9dWl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe9dml8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEe9d2l8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe9eGl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEe9eWl8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEe9eml8Ee2Ub5oQ2PlTWg" value="BINARY"/>
            </node>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPhfr9aEeqccNI2vvuvYA" name="COOKIE - cookie as input" position="2">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPhf79aEeqccNI2vvuvYA" value="cookie"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPhgL9aEeqccNI2vvuvYA" value="Sending Cookies"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_Oi9l8L9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'cookie' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/cookie&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send cookies in a request"/>
      <node defType="com.stambia.http.rest.operation" id="_INPhgb9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPhgr9aEeqccNI2vvuvYA" value="GET"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_oU5yoL9gEeqccNI2vvuvYA" value="Sending cookies"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_tV_t8L9gEeqccNI2vvuvYA" value="This operation will send a GET request with defined cookie Parameters.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the reponse through the responses defined under 'Responses' node.&#xD;&#xA;"/>
        <node defType="com.stambia.http.rest.responses" id="_INPhg79aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.response" id="_INPhhL9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.response.code" id="_INPhhb9aEeqccNI2vvuvYA" value="200"/>
            <node defType="com.stambia.http.rest.respinfos" id="_s78Eor9fEeqccNI2vvuvYA">
              <node defType="com.stambia.http.rest.respinfo" id="_u5U-YL9fEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_0YFtIL9fEeqccNI2vvuvYA" value="statusCode"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.parameters" id="_RtLOMHV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.parameter" id="_XEe9mml8Ee2Ub5oQ2PlTWg" name="do-you-like-cookie">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9m2l8Ee2Ub5oQ2PlTWg" value="cookie"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_XEe9nGl8Ee2Ub5oQ2PlTWg" value="Yes!"/>
            <attribute defType="com.stambia.http.rest.parameter.required" id="_XEe9nWl8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_XEe9nml8Ee2Ub5oQ2PlTWg" value="This cookie is marked as required.&#xD;&#xA;&#xD;&#xA;It will therfore always be sent in the request and must be defined.&#xD;&#xA;&#xD;&#xA;In the Mapping, if no value is defined on this parameter, the default value will be sent."/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_XEe9l2l8Ee2Ub5oQ2PlTWg" name="other-cookie">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9mGl8Ee2Ub5oQ2PlTWg" value="cookie"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_XEe9mWl8Ee2Ub5oQ2PlTWg" value="This cookie is not marked as required, being therefore optional.&#xD;&#xA;&#xD;&#xA;It will be sent only when a value is defined in Mapping."/>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPhl79aEeqccNI2vvuvYA" name="FORM - form parameters as input and output" position="4">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPhmL9aEeqccNI2vvuvYA" value="form"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPhmb9aEeqccNI2vvuvYA" value="FORM data as input and output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_VBOp4L9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'form' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/form&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send and retrieve HTTP FORM data which will be added inside the request body"/>
      <node defType="com.stambia.http.rest.operation" id="_INPhmr9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPhm79aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_CXqJ4L9hEeqccNI2vvuvYA" value="Sending and receiving FORM data"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_MkdVEL9hEeqccNI2vvuvYA" value="This operation will send a POST request with defined FORM data.&#xD;&#xA;&#xD;&#xA;The FORM parameters are defined under the content node, and will be sent in the body of the request.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve a returned FORM data reponse through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <node defType="com.stambia.http.rest.responses" id="_INPhoL9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.response" id="_INPhob9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_XE5NEGl8Ee2Ub5oQ2PlTWg" value="FORM"/>
            <node defType="com.stambia.http.rest.headers" id="_INPho79aEeqccNI2vvuvYA">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XE50IGl8Ee2Ub5oQ2PlTWg" value="FORM"/>
              <node defType="com.stambia.http.rest.header" id="_INPhpL9aEeqccNI2vvuvYA" name="Content-type"/>
              <node defType="com.stambia.http.rest.formvalue" id="_XEe9rml8Ee2Ub5oQ2PlTWg" name="output_form_parameter_01"/>
              <node defType="com.stambia.http.rest.formvalue" id="_XEe9sGl8Ee2Ub5oQ2PlTWg" name="output_form_parameter_03"/>
              <node defType="com.stambia.http.rest.formvalue" id="_XEe9sWl8Ee2Ub5oQ2PlTWg" name="output_form_parameter_04"/>
              <node defType="com.stambia.http.rest.formvalue" id="_XEe9r2l8Ee2Ub5oQ2PlTWg" name="output_form_parameter_02"/>
            </node>
            <node defType="com.stambia.http.rest.formvalue" id="_XEe9tWl8Ee2Ub5oQ2PlTWg" name="form_parameter_01"/>
            <node defType="com.stambia.http.rest.formvalue" id="_XEe9tml8Ee2Ub5oQ2PlTWg" name="form_parameter_02"/>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPhtL9aEeqccNI2vvuvYA" name="HEADER - headers as input and output" position="5">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPhtb9aEeqccNI2vvuvYA" value="http_header"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPhtr9aEeqccNI2vvuvYA" value="HTTP Headers as input and output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_aS5X0L9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'http_header' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/http_header&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send and retrieve HTTP Headers."/>
      <node defType="com.stambia.http.rest.operation" id="_INPht79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPhuL9aEeqccNI2vvuvYA" value="GET"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_YOqc8L9iEeqccNI2vvuvYA" value="This operation will send a GET request with defined input HTTP Headers parameters.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve response HTTP Headers through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_a9HAML9iEeqccNI2vvuvYA" value="Sending and retrieving HTTP Headers"/>
        <node defType="com.stambia.http.rest.responses" id="_INPhub9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.response" id="_INPhur9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.response.code" id="_INPhu79aEeqccNI2vvuvYA" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_INPhvL9aEeqccNI2vvuvYA">
              <node defType="com.stambia.http.rest.header" id="_INPhvb9aEeqccNI2vvuvYA" name="Content-type"/>
              <node defType="com.stambia.http.rest.header" id="_INPhvr9aEeqccNI2vvuvYA" name="response_header_a"/>
              <node defType="com.stambia.http.rest.header" id="_INPhv79aEeqccNI2vvuvYA" name="response_header_b"/>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.parameters" id="_aFztEHV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.parameter" id="_XEe9x2l8Ee2Ub5oQ2PlTWg" name="input_header_01">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9yGl8Ee2Ub5oQ2PlTWg" value="header"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_XEe9yWl8Ee2Ub5oQ2PlTWg" value="default_value_01"/>
            <attribute defType="com.stambia.http.rest.parameter.required" id="_XEe9yml8Ee2Ub5oQ2PlTWg" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_XEe9y2l8Ee2Ub5oQ2PlTWg" value="This header is marked as required.&#xD;&#xA;&#xD;&#xA;It will therfore always be sent in the request and must be defined.&#xD;&#xA;&#xD;&#xA;In the Mapping, if no value is defined on this parameter, the default value will be sent."/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_XEe9zGl8Ee2Ub5oQ2PlTWg" name="input_header_02">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe9zWl8Ee2Ub5oQ2PlTWg" value="header"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_XEe9zml8Ee2Ub5oQ2PlTWg" value="This header is not marked as required, being therefore optional.&#xD;&#xA;&#xD;&#xA;It will be sent only when a value is defined in Mapping."/>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPh679aEeqccNI2vvuvYA" name="JSON - common - json as input and output" position="6">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPh7L9aEeqccNI2vvuvYA" value="json"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPh7b9aEeqccNI2vvuvYA" value="JSON as input and output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_e0RRQL9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'json' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/json&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send and retrieve JSON structures."/>
      <node defType="com.stambia.http.rest.operation" id="_INPh7r9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPh779aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_04aEkL9iEeqccNI2vvuvYA" value="This operation will send a POST request with defined input JSON structure.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the JSON response through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_62Fj8L9iEeqccNI2vvuvYA" value="Sending and retrieving JSON data"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INPh8L9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INPh8b9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INPh8r9aEeqccNI2vvuvYA" value="JSON"/>
            <node defType="com.stambia.json.rootObject" id="_INPh879aEeqccNI2vvuvYA" name="customer">
              <attribute defType="com.stambia.json.rootObject.encoding" id="_INPh9L9aEeqccNI2vvuvYA" value="UTF-8"/>
              <node defType="com.stambia.json.value" id="_INPh979aEeqccNI2vvuvYA" name="tit_code" position="1">
                <attribute defType="com.stambia.json.value.type" id="_INPh-L9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPh-b9aEeqccNI2vvuvYA" name="cus_last_name" position="2">
                <attribute defType="com.stambia.json.value.type" id="_INPh-r9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPh-79aEeqccNI2vvuvYA" name="cus_first_name" position="3">
                <attribute defType="com.stambia.json.value.type" id="_INPh_L9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPh_b9aEeqccNI2vvuvYA" name="cus_company" position="4">
                <attribute defType="com.stambia.json.value.type" id="_INPh_r9aEeqccNI2vvuvYA" value="string"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_cnBsonV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe95Wl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe95ml8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.content" id="_XEe952l8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEe96Gl8Ee2Ub5oQ2PlTWg" value="JSON"/>
              <node defType="com.stambia.json.rootObject" id="_XEe96Wl8Ee2Ub5oQ2PlTWg" name="response">
                <attribute defType="com.stambia.json.rootObject.encoding" id="_XEe96ml8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                <node defType="com.stambia.json.object" id="_XEe962l8Ee2Ub5oQ2PlTWg" name="response" position="1">
                  <node defType="com.stambia.json.object" id="_XEe97Gl8Ee2Ub5oQ2PlTWg" name="data" position="1">
                    <node defType="com.stambia.json.object" id="_XEe97Wl8Ee2Ub5oQ2PlTWg" name="customer" position="1">
                      <node defType="com.stambia.json.value" id="_XEe97ml8Ee2Ub5oQ2PlTWg" name="cus_id" position="1">
                        <attribute defType="com.stambia.json.value.type" id="_XEe972l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe98Gl8Ee2Ub5oQ2PlTWg" name="tit_code" position="2">
                        <attribute defType="com.stambia.json.value.type" id="_XEe98Wl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe98ml8Ee2Ub5oQ2PlTWg" name="cus_last_name" position="4">
                        <attribute defType="com.stambia.json.value.type" id="_XEe982l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe99Gl8Ee2Ub5oQ2PlTWg" name="cus_first_name" position="3">
                        <attribute defType="com.stambia.json.value.type" id="_XEe99Wl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe99ml8Ee2Ub5oQ2PlTWg" name="cus_company" position="5">
                        <attribute defType="com.stambia.json.value.type" id="_XEe992l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                    </node>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.headers" id="_XEe9-Gl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe9-Wl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
          </node>
        </node>
      </node>
      <node defType="com.stambia.http.rest.operation" id="_INPie79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPifL9aEeqccNI2vvuvYA" value="GET"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_4cdaIL9iEeqccNI2vvuvYA" value="This operation will send a GET request with defined input JSON structure.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the JSON response through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_7VCw0L9iEeqccNI2vvuvYA" value="Sending and retrieving JSON data"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INPifb9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INPifr9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INPif79aEeqccNI2vvuvYA" value="JSON"/>
            <node defType="com.stambia.json.rootObject" id="_INPigL9aEeqccNI2vvuvYA" name="customer">
              <attribute defType="com.stambia.json.rootObject.encoding" id="_INPigb9aEeqccNI2vvuvYA" value="UTF-8"/>
              <node defType="com.stambia.json.value" id="_INPihL9aEeqccNI2vvuvYA" name="tit_code" position="1">
                <attribute defType="com.stambia.json.value.type" id="_INPihb9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPihr9aEeqccNI2vvuvYA" name="cus_last_name" position="2">
                <attribute defType="com.stambia.json.value.type" id="_INPih79aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPiiL9aEeqccNI2vvuvYA" name="cus_first_name" position="3">
                <attribute defType="com.stambia.json.value.type" id="_INPiib9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INPiir9aEeqccNI2vvuvYA" name="cus_company" position="4">
                <attribute defType="com.stambia.json.value.type" id="_INPii79aEeqccNI2vvuvYA" value="string"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_eNwZ4nV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe-DGl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe-DWl8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.content" id="_XEe-Dml8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEe-D2l8Ee2Ub5oQ2PlTWg" value="JSON"/>
              <node defType="com.stambia.json.rootObject" id="_XEe-EGl8Ee2Ub5oQ2PlTWg" name="response">
                <attribute defType="com.stambia.json.rootObject.encoding" id="_XEe-EWl8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                <node defType="com.stambia.json.object" id="_XEe-Eml8Ee2Ub5oQ2PlTWg" name="response" position="1">
                  <node defType="com.stambia.json.object" id="_XEe-E2l8Ee2Ub5oQ2PlTWg" name="data" position="1">
                    <node defType="com.stambia.json.object" id="_XEe-FGl8Ee2Ub5oQ2PlTWg" name="customer" position="1">
                      <node defType="com.stambia.json.value" id="_XEe-FWl8Ee2Ub5oQ2PlTWg" name="cus_id" position="1">
                        <attribute defType="com.stambia.json.value.type" id="_XEe-Fml8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe-F2l8Ee2Ub5oQ2PlTWg" name="tit_code" position="2">
                        <attribute defType="com.stambia.json.value.type" id="_XEe-GGl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe-GWl8Ee2Ub5oQ2PlTWg" name="cus_last_name" position="4">
                        <attribute defType="com.stambia.json.value.type" id="_XEe-Gml8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe-G2l8Ee2Ub5oQ2PlTWg" name="cus_first_name" position="3">
                        <attribute defType="com.stambia.json.value.type" id="_XEe-HGl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEe-HWl8Ee2Ub5oQ2PlTWg" name="cus_company" position="5">
                        <attribute defType="com.stambia.json.value.type" id="_XEe-Hml8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                    </node>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.headers" id="_XEe-H2l8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe-IGl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPi2b9aEeqccNI2vvuvYA" name="Response Information - retrieve response information such as status code" position="7">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPi2r9aEeqccNI2vvuvYA" value="response_information_retrieval"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPi279aEeqccNI2vvuvYA" value="Retrieve response information such as status code"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_p2WeoL9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'response_information_retrieval' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/response_information_retrieval&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to retrieve response technical information such as:&#xD;&#xA;* HTTP Status Code&#xD;&#xA;* HTTP Protocol Version&#xD;&#xA;* HTTP Reason Phrase&#xD;&#xA;"/>
      <node defType="com.stambia.http.rest.operation" id="_INPi3L9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPi3b9aEeqccNI2vvuvYA" value="GET"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_bt5ugL9jEeqccNI2vvuvYA" value="Retrieving technical response information"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_eLrYgL9jEeqccNI2vvuvYA" value="This operation demonstrates how to retrivie technical information about the response, such as:&#xD;&#xA;* HTTP Status Code&#xD;&#xA;* HTTP Protocol Version&#xD;&#xA;* HTTP Reason Phrase"/>
        <node defType="com.stambia.http.rest.responses" id="_INPi3r9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.response" id="_INPi379aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.response.code" id="_INPi4L9aEeqccNI2vvuvYA" value="default"/>
            <node defType="com.stambia.http.rest.respinfos" id="_INPi5L9aEeqccNI2vvuvYA">
              <node defType="com.stambia.http.rest.respinfo" id="_INPi5b9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi5r9aEeqccNI2vvuvYA" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPi579aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi6L9aEeqccNI2vvuvYA" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPi6b9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi6r9aEeqccNI2vvuvYA" value="statusCode"/>
              </node>
            </node>
          </node>
          <node defType="com.stambia.http.rest.response" id="_INPi679aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.response.code" id="_INPi7L9aEeqccNI2vvuvYA" value="200"/>
            <node defType="com.stambia.http.rest.respinfos" id="_INPi8L9aEeqccNI2vvuvYA">
              <node defType="com.stambia.http.rest.respinfo" id="_INPi8b9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi8r9aEeqccNI2vvuvYA" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPi879aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi9L9aEeqccNI2vvuvYA" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPi9b9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi9r9aEeqccNI2vvuvYA" value="statusCode"/>
              </node>
            </node>
          </node>
          <node defType="com.stambia.http.rest.response" id="_INPi979aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.response.code" id="_INPi-L9aEeqccNI2vvuvYA" value="404"/>
            <node defType="com.stambia.http.rest.respinfos" id="_INPi_L9aEeqccNI2vvuvYA">
              <node defType="com.stambia.http.rest.respinfo" id="_INPi_b9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPi_r9aEeqccNI2vvuvYA" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPi_79aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPjAL9aEeqccNI2vvuvYA" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_INPjAb9aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_INPjAr9aEeqccNI2vvuvYA" value="statusCode"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.parameters" id="_hcFXEHV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.parameter" id="_XEe-Rml8Ee2Ub5oQ2PlTWg" name="input_header_01">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEe-R2l8Ee2Ub5oQ2PlTWg" value="header"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_XEe-SGl8Ee2Ub5oQ2PlTWg" value="default_value_01"/>
            <attribute defType="com.stambia.http.rest.parameter.required" id="_XEe-SWl8Ee2Ub5oQ2PlTWg" value="true"/>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPjCL9aEeqccNI2vvuvYA" name="TEXT PLAIN - text plain as input and output" position="8">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPjCb9aEeqccNI2vvuvYA" value="text_plain"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPjCr9aEeqccNI2vvuvYA" value="Text plain as intput and output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_5Mh-cL9dEeqccNI2vvuvYA" value="This path corresponds to a resource called 'text_plain' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/text_plain&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send and retrieve text/plain data&#xD;&#xA;"/>
      <node defType="com.stambia.http.rest.operation" id="_INPjC79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPjDL9aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_mPlkkL9jEeqccNI2vvuvYA" value="This operation will send a POST request with text/plain data as input.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve a text/plain response through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_PodNYL9oEeqccNI2vvuvYA" value="Text plain as intput and output"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INPjEb9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INPjEr9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INPjE79aEeqccNI2vvuvYA" value="TEXT"/>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_juoognV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe-Vml8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe-V2l8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEe-WGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe-WWl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEe-Wml8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEe-W2l8Ee2Ub5oQ2PlTWg" value="TEXT"/>
            </node>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPjHb9aEeqccNI2vvuvYA" name="URL Query Parameter - common - query parameters as input" position="9">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPjHr9aEeqccNI2vvuvYA" value="url_query_parameter"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPjH79aEeqccNI2vvuvYA" value="Sending URL Query Parameters"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_toNKML9eEeqccNI2vvuvYA" value="This path corresponds to a resource called 'url_query_parameter' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This example demonstrates how to define URL Query parameters, which are defined directly on the operation through &quot;query&quot; parameters.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/url_query_parameter?parameter_01=valueA&amp;parameter_02=valueB&#xD;&#xA;&#xD;&#xA;"/>
      <node defType="com.stambia.http.rest.operation" id="_INPjIL9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPjIb9aEeqccNI2vvuvYA" value="GET"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_n-ZaUL9kEeqccNI2vvuvYA" value="This operation will send a GET request with defined input query parameters.&#xD;&#xA;&#xD;&#xA;Query parameters defined in the operation are added in the URL at invocation.&#xD;&#xA;&#xD;&#xA;For instance:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/url_query_parameter?parameter_01=valueA&amp;parameter_02=valueB&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_oeDx0L9kEeqccNI2vvuvYA" value="Working with URL Query Parameters"/>
        <node defType="com.stambia.http.rest.parameters" id="_INPjIr9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.parameter" id="_INPjJr9aEeqccNI2vvuvYA" name="parameter_01">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_INPjJ79aEeqccNI2vvuvYA" value="query"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_INPjKL9aEeqccNI2vvuvYA" value="valueA"/>
            <attribute defType="com.stambia.http.rest.parameter.required" id="_wjOiIL9kEeqccNI2vvuvYA" value="true"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_G7_68L9lEeqccNI2vvuvYA" value="This query parameter is marked as required.&#xD;&#xA;&#xD;&#xA;It will therfore always be sent in the request and must be defined.&#xD;&#xA;&#xD;&#xA;In the Mapping, if no value is defined on this parameter, the default value will be sent."/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_INPjKb9aEeqccNI2vvuvYA" name="parameter_02">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_INPjKr9aEeqccNI2vvuvYA" value="query"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_JX9AAL9lEeqccNI2vvuvYA" value="This query parameter is not marked as required, being therefore optional.&#xD;&#xA;&#xD;&#xA;It will be sent only when a value is defined in Mapping."/>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_n2qN0nV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe-bml8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe-b2l8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEe-cGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe-cWl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEe-cml8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEe-c2l8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEe-dGl8Ee2Ub5oQ2PlTWg" value="statusCode"/>
              </node>
            </node>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INPjWL9aEeqccNI2vvuvYA" name="XML - common - xml as input and output" position="10">
      <attribute defType="com.stambia.http.rest.path.path" id="_INPjWb9aEeqccNI2vvuvYA" value="xml"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INPjWr9aEeqccNI2vvuvYA" value="XML as Input and Output"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_B9j5wL9fEeqccNI2vvuvYA" value="This path corresponds to a resource called 'xml' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/xml&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to send and retrieve XML structures."/>
      <node defType="com.stambia.http.rest.operation" id="_INPjW79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INPjXL9aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_MzVMoL9jEeqccNI2vvuvYA" value="This operation will send a POST request with defined input XML structure.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the XML response through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_RoRiUL9jEeqccNI2vvuvYA" value="Sending and retrieving XML data"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INPjXb9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INPjXr9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.contentType" id="_INPjX79aEeqccNI2vvuvYA" value="text/xml"/>
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INPjYL9aEeqccNI2vvuvYA" value="XML"/>
            <node defType="com.stambia.xml.element" id="_INPjYb9aEeqccNI2vvuvYA" name="customer_input">
              <attribute defType="com.stambia.xml.element.originalType" id="_INPjYr9aEeqccNI2vvuvYA" value="customer_input"/>
              <node defType="com.stambia.xml.sequence" id="_INPjY79aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.xml.sequence.position" id="_INPjZL9aEeqccNI2vvuvYA" value="0"/>
                <node defType="com.stambia.xml.element" id="_INPjZb9aEeqccNI2vvuvYA" name="tit_code">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INPjZr9aEeqccNI2vvuvYA" value="tit_code"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INPjZ79aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INPjaL9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INPjab9aEeqccNI2vvuvYA" name="cus_last_name">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INPjar9aEeqccNI2vvuvYA" value="cus_last_name"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INPja79aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INPjbL9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INPjbb9aEeqccNI2vvuvYA" name="cus_first_name">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INPjbr9aEeqccNI2vvuvYA" value="cus_first_name"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INPjb79aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INPjcL9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INPjcb9aEeqccNI2vvuvYA" name="cus_company">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INPjcr9aEeqccNI2vvuvYA" value="cus_company"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INPjc79aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INPjdL9aEeqccNI2vvuvYA" value="1"/>
                </node>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_qVCUwnV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEe-lml8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEe-l2l8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEe-mGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEe-mWl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEe-mml8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.contentType" id="_XEe-m2l8Ee2Ub5oQ2PlTWg" value="text/xml"/>
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEe-nGl8Ee2Ub5oQ2PlTWg" value="XML"/>
              <node defType="com.stambia.xml.element" id="_XEe-nWl8Ee2Ub5oQ2PlTWg" name="customer_output">
                <attribute defType="com.stambia.xml.element.originalType" id="_XEe-nml8Ee2Ub5oQ2PlTWg" value="customer_output"/>
                <node defType="com.stambia.xml.sequence" id="_XEe-n2l8Ee2Ub5oQ2PlTWg">
                  <attribute defType="com.stambia.xml.sequence.position" id="_XEe-oGl8Ee2Ub5oQ2PlTWg" value="0"/>
                  <node defType="com.stambia.xml.element" id="_XEe-oWl8Ee2Ub5oQ2PlTWg" name="cus_id">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEe-oml8Ee2Ub5oQ2PlTWg" value="cus_id"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEe-o2l8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEe-pGl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEe-pWl8Ee2Ub5oQ2PlTWg" name="tit_code">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEe-pml8Ee2Ub5oQ2PlTWg" value="tit_code"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEe-p2l8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEe-qGl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEe-qWl8Ee2Ub5oQ2PlTWg" name="cus_last_name">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEe-qml8Ee2Ub5oQ2PlTWg" value="cus_last_name"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEe-q2l8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEe-rGl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEe-rWl8Ee2Ub5oQ2PlTWg" name="cus_first_name">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEe-rml8Ee2Ub5oQ2PlTWg" value="cus_first_name"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEe-r2l8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEe-sGl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEe-sWl8Ee2Ub5oQ2PlTWg" name="cus_company">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEe-sml8Ee2Ub5oQ2PlTWg" value="cus_company"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEe-s2l8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEe-tGl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                </node>
              </node>
            </node>
          </node>
        </node>
      </node>
      <node defType="com.stambia.http.rest.operation" id="_INQIw79aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INQIxL9aEeqccNI2vvuvYA" value="PUT"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_QTF4EL9jEeqccNI2vvuvYA" value="This operation will send a PUT request with defined input XML structure.&#xD;&#xA;&#xD;&#xA;After invocation, it will be possible to retrieve the XML response through the responses defined under 'Responses' node.&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_SPxnML9jEeqccNI2vvuvYA" value="Sending and retrieving XML data"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INQIxb9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INQIxr9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.contentType" id="_INQIx79aEeqccNI2vvuvYA" value="text/xml"/>
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INQIyL9aEeqccNI2vvuvYA" value="XML"/>
            <node defType="com.stambia.xml.element" id="_INQIyb9aEeqccNI2vvuvYA" name="customer_input">
              <attribute defType="com.stambia.xml.element.originalType" id="_INQIyr9aEeqccNI2vvuvYA" value="customer_input"/>
              <node defType="com.stambia.xml.sequence" id="_INQIy79aEeqccNI2vvuvYA">
                <attribute defType="com.stambia.xml.sequence.position" id="_INQIzL9aEeqccNI2vvuvYA" value="0"/>
                <node defType="com.stambia.xml.element" id="_INQIzb9aEeqccNI2vvuvYA" name="tit_code">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INQIzr9aEeqccNI2vvuvYA" value="tit_code"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INQIz79aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INQI0L9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INQI0b9aEeqccNI2vvuvYA" name="cus_last_name">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INQI0r9aEeqccNI2vvuvYA" value="cus_last_name"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INQI079aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INQI1L9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INQI1b9aEeqccNI2vvuvYA" name="cus_first_name">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INQI1r9aEeqccNI2vvuvYA" value="cus_first_name"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INQI179aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INQI2L9aEeqccNI2vvuvYA" value="1"/>
                </node>
                <node defType="com.stambia.xml.element" id="_INQI2b9aEeqccNI2vvuvYA" name="cus_company">
                  <attribute defType="com.stambia.xml.element.originalType" id="_INQI2r9aEeqccNI2vvuvYA" value="cus_company"/>
                  <attribute defType="com.stambia.xml.element.minOccurs" id="_INQI279aEeqccNI2vvuvYA" value="0"/>
                  <attribute defType="com.stambia.xml.element.maxOccurs" id="_INQI3L9aEeqccNI2vvuvYA" value="1"/>
                </node>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_ruW4InV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEfke2l8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEfkfGl8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEfkfWl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEfkfml8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEfkf2l8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.contentType" id="_XEfkgGl8Ee2Ub5oQ2PlTWg" value="text/xml"/>
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEfkgWl8Ee2Ub5oQ2PlTWg" value="XML"/>
              <node defType="com.stambia.xml.element" id="_XEfkgml8Ee2Ub5oQ2PlTWg" name="customer_output">
                <attribute defType="com.stambia.xml.element.originalType" id="_XEfkg2l8Ee2Ub5oQ2PlTWg" value="customer_output"/>
                <node defType="com.stambia.xml.sequence" id="_XEfkhGl8Ee2Ub5oQ2PlTWg">
                  <attribute defType="com.stambia.xml.sequence.position" id="_XEfkhWl8Ee2Ub5oQ2PlTWg" value="0"/>
                  <node defType="com.stambia.xml.element" id="_XEfkhml8Ee2Ub5oQ2PlTWg" name="cus_id">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEfkh2l8Ee2Ub5oQ2PlTWg" value="cus_id"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEfkiGl8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEfkiWl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEfkiml8Ee2Ub5oQ2PlTWg" name="tit_code">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEfki2l8Ee2Ub5oQ2PlTWg" value="tit_code"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEfkjGl8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEfkjWl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEfkjml8Ee2Ub5oQ2PlTWg" name="cus_last_name">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEfkj2l8Ee2Ub5oQ2PlTWg" value="cus_last_name"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEfkkGl8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEfkkWl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEfkkml8Ee2Ub5oQ2PlTWg" name="cus_first_name">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEfkk2l8Ee2Ub5oQ2PlTWg" value="cus_first_name"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEfklGl8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEfklWl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                  <node defType="com.stambia.xml.element" id="_XEfklml8Ee2Ub5oQ2PlTWg" name="cus_company">
                    <attribute defType="com.stambia.xml.element.originalType" id="_XEfkl2l8Ee2Ub5oQ2PlTWg" value="cus_company"/>
                    <attribute defType="com.stambia.xml.element.minOccurs" id="_XEfkmGl8Ee2Ub5oQ2PlTWg" value="0"/>
                    <attribute defType="com.stambia.xml.element.maxOccurs" id="_XEfkmWl8Ee2Ub5oQ2PlTWg" value="1"/>
                  </node>
                </node>
              </node>
            </node>
          </node>
        </node>
      </node>
    </node>
    <node defType="com.stambia.http.rest.path" id="_INQJ8b9aEeqccNI2vvuvYA" name="URL Path Parameter - common - path parameter as input">
      <attribute defType="com.stambia.http.rest.path.path" id="_INQJ8r9aEeqccNI2vvuvYA" value="url_path_parameter/{parameter_01}/{parameter_02}"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_EinF4L9eEeqccNI2vvuvYA" value="This path corresponds to a resource called 'url_path_parameter' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;We here have some parameters which are located in the &quot;path&quot; of the request.&#xD;&#xA;&#xD;&#xA;There are defined through the {parameter_name} syntax in the URL, and defined as &quot;path&quot; parameter under the operation.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore generates something like:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/A/url_path_parameter/valueA/valueB&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_E_xpkL-LEeqvP9KdpB2ijg" value="Working with URL Path parameters"/>
      <node defType="com.stambia.http.rest.operation" id="_INQJ879aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INQJ9L9aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_CkiA4L9kEeqccNI2vvuvYA" value="This operation will send a POST request with defined input path parameters.&#xD;&#xA;&#xD;&#xA;When defining a path parameter, named &quot;parameter_01&quot; for instance, a corresponding parameter must be added in the path of the operation, with {parameter_01} syntax.&#xD;&#xA;&#xD;&#xA;See the parent path node for an example.&#xD;&#xA;&#xD;&#xA;Path parameters defined in the operation will replace at execution the corresponding parameters in the URL, with the values defined on those parameters in the Mapping, or the default value if no value is defined in Mapping."/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_KpfV0L9kEeqccNI2vvuvYA" value="Working with URL Path parameters"/>
        <node defType="com.stambia.http.rest.parameters" id="_INQJ9b9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.parameter" id="_INQJ-b9aEeqccNI2vvuvYA" name="parameter_01">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_INQJ-r9aEeqccNI2vvuvYA" value="path"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_INQJ-79aEeqccNI2vvuvYA" value="valueA"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_NjE8oL9lEeqccNI2vvuvYA" value="Path parameters must be &quot;required&quot; and are always sent.&#xD;&#xA;&#xD;&#xA;When no value is defined in Mapping, default value is used."/>
          </node>
          <node defType="com.stambia.http.rest.parameter" id="_INQJ_b9aEeqccNI2vvuvYA" name="parameter_02">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_INQJ_r9aEeqccNI2vvuvYA" value="path"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_INQJ_79aEeqccNI2vvuvYA" value="valueB"/>
            <attribute defType="com.stambia.http.rest.parameter.description" id="_OFLkIL9lEeqccNI2vvuvYA" value="Path parameters must be &quot;required&quot; and are always sent.&#xD;&#xA;&#xD;&#xA;When no value is defined in Mapping, default value is used."/>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_maP6MnV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEfkrGl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEfkrWl8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEfkrml8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEfkr2l8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEfksGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEfksWl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfksml8Ee2Ub5oQ2PlTWg" value="statusCode"/>
              </node>
            </node>
          </node>
        </node>
      </node>
    </node>
  </node>
  <node defType="com.stambia.http.rest.path" id="_INQJ7r9aEeqccNI2vvuvYA">
    <attribute defType="com.stambia.http.rest.path.path" id="_INQJ779aEeqccNI2vvuvYA" value="examples/B"/>
    <attribute defType="com.stambia.http.rest.path.summary" id="_INQJ8L9aEeqccNI2vvuvYA" value="Second set of examples"/>
    <attribute defType="com.stambia.http.rest.path.description" id="_pdR2UL9oEeqccNI2vvuvYA" value="This path corresponds to a resource called examples/B in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated to the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/B"/>
    <node defType="com.stambia.http.rest.path" id="_INQJg79aEeqccNI2vvuvYA" name="Z - MISCELLANEOUS - error handling" position="3">
      <attribute defType="com.stambia.http.rest.path.path" id="_INQJhL9aEeqccNI2vvuvYA" value="handling_different_responses"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_INQJhb9aEeqccNI2vvuvYA" value="Working with different responses based on the status code"/>
      <attribute defType="com.stambia.http.rest.path.description" id="_JcXNoL9fEeqccNI2vvuvYA" value="This path corresponds to a resource called 'handling_different_responses' in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated with parent paths until the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/B/handling_different_responses&#xD;&#xA;&#xD;&#xA;=> this example demonstrates how to handle different responses based on the status code"/>
      <node defType="com.stambia.http.rest.operation" id="_INQJhr9aEeqccNI2vvuvYA">
        <attribute defType="com.stambia.http.rest.operation.method" id="_INQJh79aEeqccNI2vvuvYA" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_7wUI0L9oEeqccNI2vvuvYA" value="Working with different responses based on the status code"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_-vl9YL9oEeqccNI2vvuvYA" value="This example demonstrates how to define and handle different responses based on status code"/>
        <node defType="com.stambia.http.rest.requestbody" id="_INQJiL9aEeqccNI2vvuvYA">
          <node defType="com.stambia.http.rest.content" id="_INQJib9aEeqccNI2vvuvYA">
            <attribute defType="com.stambia.http.rest.content.mediaType" id="_INQJir9aEeqccNI2vvuvYA" value="JSON"/>
            <node defType="com.stambia.json.rootObject" id="_INQJi79aEeqccNI2vvuvYA" name="customer">
              <attribute defType="com.stambia.json.rootObject.encoding" id="_INQJjL9aEeqccNI2vvuvYA" value="UTF-8"/>
              <node defType="com.stambia.json.value" id="_INQJj79aEeqccNI2vvuvYA" name="tit_code" position="1">
                <attribute defType="com.stambia.json.value.type" id="_INQJkL9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INQJkb9aEeqccNI2vvuvYA" name="cus_last_name" position="2">
                <attribute defType="com.stambia.json.value.type" id="_INQJkr9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INQJk79aEeqccNI2vvuvYA" name="cus_first_name" position="3">
                <attribute defType="com.stambia.json.value.type" id="_INQJlL9aEeqccNI2vvuvYA" value="string"/>
              </node>
              <node defType="com.stambia.json.value" id="_INQJlb9aEeqccNI2vvuvYA" name="cus_company" position="4">
                <attribute defType="com.stambia.json.value.type" id="_INQJlr9aEeqccNI2vvuvYA" value="string"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_tVRyonV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEfk_ml8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEfk_2l8Ee2Ub5oQ2PlTWg" value="default"/>
            <node defType="com.stambia.http.rest.headers" id="_XEflAGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEflAWl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEflAml8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEflA2l8Ee2Ub5oQ2PlTWg" value="JSON"/>
              <node defType="com.stambia.json.rootObject" id="_XEflBGl8Ee2Ub5oQ2PlTWg" name="response">
                <attribute defType="com.stambia.json.rootObject.encoding" id="_XEflBWl8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                <node defType="com.stambia.json.object" id="_XEflBml8Ee2Ub5oQ2PlTWg" name="response" position="1">
                  <node defType="com.stambia.json.object" id="_XEflB2l8Ee2Ub5oQ2PlTWg" name="status" position="1">
                    <node defType="com.stambia.json.value" id="_XEflCGl8Ee2Ub5oQ2PlTWg" name="status" position="1">
                      <attribute defType="com.stambia.json.value.type" id="_XEflCWl8Ee2Ub5oQ2PlTWg" value="string"/>
                    </node>
                    <node defType="com.stambia.json.value" id="_XEflCml8Ee2Ub5oQ2PlTWg" name="message" position="2">
                      <attribute defType="com.stambia.json.value.type" id="_XEflC2l8Ee2Ub5oQ2PlTWg" value="string"/>
                    </node>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEflDGl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEflDWl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEflDml8Ee2Ub5oQ2PlTWg" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEflD2l8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEflEGl8Ee2Ub5oQ2PlTWg" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEflEWl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEflEml8Ee2Ub5oQ2PlTWg" value="statusCode"/>
              </node>
            </node>
          </node>
          <node defType="com.stambia.http.rest.response" id="_XEfkzWl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEfkzml8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.content" id="_XEfkz2l8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEfk0Gl8Ee2Ub5oQ2PlTWg" value="JSON"/>
              <node defType="com.stambia.json.rootObject" id="_XEfk0Wl8Ee2Ub5oQ2PlTWg" name="response">
                <attribute defType="com.stambia.json.rootObject.encoding" id="_XEfk0ml8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                <node defType="com.stambia.json.object" id="_XEfk02l8Ee2Ub5oQ2PlTWg" name="response" position="1">
                  <node defType="com.stambia.json.object" id="_XEfk1Gl8Ee2Ub5oQ2PlTWg" name="data" position="1">
                    <node defType="com.stambia.json.object" id="_XEfk1Wl8Ee2Ub5oQ2PlTWg" name="customer" position="1">
                      <node defType="com.stambia.json.value" id="_XEfk1ml8Ee2Ub5oQ2PlTWg" name="cus_id" position="1">
                        <attribute defType="com.stambia.json.value.type" id="_XEfk12l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEfk2Gl8Ee2Ub5oQ2PlTWg" name="tit_code" position="2">
                        <attribute defType="com.stambia.json.value.type" id="_XEfk2Wl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEfk2ml8Ee2Ub5oQ2PlTWg" name="cus_last_name" position="4">
                        <attribute defType="com.stambia.json.value.type" id="_XEfk22l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEfk3Gl8Ee2Ub5oQ2PlTWg" name="cus_first_name" position="3">
                        <attribute defType="com.stambia.json.value.type" id="_XEfk3Wl8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                      <node defType="com.stambia.json.value" id="_XEfk3ml8Ee2Ub5oQ2PlTWg" name="cus_company" position="5">
                        <attribute defType="com.stambia.json.value.type" id="_XEfk32l8Ee2Ub5oQ2PlTWg" value="string"/>
                      </node>
                    </node>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.headers" id="_XEfk4Gl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEfk4Wl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEfk4ml8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk42l8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk5Gl8Ee2Ub5oQ2PlTWg" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk5Wl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk5ml8Ee2Ub5oQ2PlTWg" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk52l8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk6Gl8Ee2Ub5oQ2PlTWg" value="statusCode"/>
              </node>
            </node>
          </node>
          <node defType="com.stambia.http.rest.response" id="_XEfk6Wl8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEfk6ml8Ee2Ub5oQ2PlTWg" value="400"/>
            <node defType="com.stambia.http.rest.headers" id="_XEfk62l8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEfk7Gl8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.content" id="_XEfk7Wl8Ee2Ub5oQ2PlTWg">
              <attribute defType="com.stambia.http.rest.content.mediaType" id="_XEfk7ml8Ee2Ub5oQ2PlTWg" value="JSON"/>
              <node defType="com.stambia.json.rootObject" id="_XEfk72l8Ee2Ub5oQ2PlTWg" name="response">
                <attribute defType="com.stambia.json.rootObject.encoding" id="_XEfk8Gl8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                <node defType="com.stambia.json.object" id="_XEfk8Wl8Ee2Ub5oQ2PlTWg" name="response" position="1">
                  <node defType="com.stambia.json.object" id="_XEfk8ml8Ee2Ub5oQ2PlTWg" name="status" position="1">
                    <node defType="com.stambia.json.value" id="_XEfk82l8Ee2Ub5oQ2PlTWg" name="status" position="1">
                      <attribute defType="com.stambia.json.value.type" id="_XEfk9Gl8Ee2Ub5oQ2PlTWg" value="string"/>
                    </node>
                    <node defType="com.stambia.json.value" id="_XEfk9Wl8Ee2Ub5oQ2PlTWg" name="message" position="2">
                      <attribute defType="com.stambia.json.value.type" id="_XEfk9ml8Ee2Ub5oQ2PlTWg" value="string"/>
                    </node>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEfk92l8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk-Gl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk-Wl8Ee2Ub5oQ2PlTWg" value="protocolVersion"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk-ml8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk-2l8Ee2Ub5oQ2PlTWg" value="reasonPhrase"/>
              </node>
              <node defType="com.stambia.http.rest.respinfo" id="_XEfk_Gl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEfk_Wl8Ee2Ub5oQ2PlTWg" value="statusCode"/>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.parameters" id="_vBMh4HV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.parameter" id="_XEflFGl8Ee2Ub5oQ2PlTWg" name="input_Header_01">
            <attribute defType="com.stambia.http.rest.parameter.location" id="_XEflFWl8Ee2Ub5oQ2PlTWg" value="header"/>
            <attribute defType="com.stambia.http.rest.parameter.default" id="_XEflFml8Ee2Ub5oQ2PlTWg" value="valueA"/>
          </node>
        </node>
      </node>
    </node>
  </node>
  <node defType="com.stambia.http.rest.path" id="_maqv7FpsEeujdeZP96RBZw">
    <attribute defType="com.stambia.http.rest.path.path" id="_maqv7VpsEeujdeZP96RBZw" value="examples/C"/>
    <attribute defType="com.stambia.http.rest.path.summary" id="_maqv7lpsEeujdeZP96RBZw" value="Third set of examples"/>
    <attribute defType="com.stambia.http.rest.path.description" id="_maqv71psEeujdeZP96RBZw" value="This path corresponds to a resource called examples/C in which we'll perfom some operations.&#xD;&#xA;&#xD;&#xA;This will be concatenated to the Endpoint Base URL.&#xD;&#xA;&#xD;&#xA;At this point, it will therefore be:&#xD;&#xA;http://hostname:8080/endpoint/base/url/examples/C"/>
    <node defType="com.stambia.http.rest.path" id="_p-DWsFpsEeujdeZP96RBZw">
      <attribute defType="com.stambia.http.rest.path.path" id="_sMYPcFpsEeujdeZP96RBZw" value="multipart-example-a"/>
      <attribute defType="com.stambia.http.rest.path.summary" id="_uqAvgFpsEeujdeZP96RBZw" value="Multipart Examples"/>
      <node defType="com.stambia.http.rest.operation" id="_qoOVEVpsEeujdeZP96RBZw">
        <attribute defType="com.stambia.http.rest.operation.method" id="_wMNiEFpsEeujdeZP96RBZw" value="POST"/>
        <attribute defType="com.stambia.http.rest.operation.summary" id="_49z9wFpwEeujdeZP96RBZw" value="sending multipart data"/>
        <attribute defType="com.stambia.http.rest.operation.description" id="_9afkcFpwEeujdeZP96RBZw" value="This operation demonstrates how to design and work with multipart requests"/>
        <node defType="com.stambia.http.rest.requestbody" id="_vKDhgVpsEeujdeZP96RBZw">
          <node defType="com.stambia.http.rest.multipart" id="_xC5ScVpsEeujdeZP96RBZw">
            <node defType="com.stambia.http.rest.part" id="_xvwYcFpsEeujdeZP96RBZw">
              <attribute defType="com.stambia.http.rest.part.partName" id="_U2UOUFp0EeujdeZP96RBZw" value="customerData"/>
              <node defType="com.stambia.http.rest.content" id="_PPC2EFpvEeujdeZP96RBZw">
                <attribute defType="com.stambia.http.rest.content.mediaType" id="_QGe0YFpvEeujdeZP96RBZw" value="JSON"/>
                <node defType="com.stambia.json.rootObject" id="_XEflLGl8Ee2Ub5oQ2PlTWg" name="customer">
                  <attribute defType="com.stambia.json.rootObject.encoding" id="_XEflLWl8Ee2Ub5oQ2PlTWg" value="UTF-8"/>
                  <node defType="com.stambia.json.value" id="_XEflLml8Ee2Ub5oQ2PlTWg" name="tit_code" position="1">
                    <attribute defType="com.stambia.json.value.type" id="_XEflL2l8Ee2Ub5oQ2PlTWg" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_XEflMGl8Ee2Ub5oQ2PlTWg" name="cus_last_name" position="2">
                    <attribute defType="com.stambia.json.value.type" id="_XEflMWl8Ee2Ub5oQ2PlTWg" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_XEflMml8Ee2Ub5oQ2PlTWg" name="cus_first_name" position="3">
                    <attribute defType="com.stambia.json.value.type" id="_XEflM2l8Ee2Ub5oQ2PlTWg" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_XEflNGl8Ee2Ub5oQ2PlTWg" name="cus_company" position="4">
                    <attribute defType="com.stambia.json.value.type" id="_XEflNWl8Ee2Ub5oQ2PlTWg" value="string"/>
                  </node>
                </node>
              </node>
            </node>
            <node defType="com.stambia.http.rest.part" id="_0v03MFpsEeujdeZP96RBZw">
              <attribute defType="com.stambia.http.rest.part.partName" id="_X-7lEFp0EeujdeZP96RBZw" value="customerData"/>
              <node defType="com.stambia.http.rest.content" id="_yTNq0FpsEeujdeZP96RBZw">
                <attribute defType="com.stambia.http.rest.content.mediaType" id="_0iatUFpsEeujdeZP96RBZw" value="JSON"/>
                <node defType="com.stambia.json.rootObject" id="_49GI7FpsEeujdeZP96RBZw" name="customer">
                  <attribute defType="com.stambia.json.rootObject.encoding" id="_49GI7VpsEeujdeZP96RBZw" value="UTF-8"/>
                  <node defType="com.stambia.json.value" id="_49GI8FpsEeujdeZP96RBZw" name="tit_code" position="1">
                    <attribute defType="com.stambia.json.value.type" id="_49GI8VpsEeujdeZP96RBZw" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_49GI8lpsEeujdeZP96RBZw" name="cus_last_name" position="2">
                    <attribute defType="com.stambia.json.value.type" id="_49GI81psEeujdeZP96RBZw" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_49GI9FpsEeujdeZP96RBZw" name="cus_first_name" position="3">
                    <attribute defType="com.stambia.json.value.type" id="_49GI9VpsEeujdeZP96RBZw" value="string"/>
                  </node>
                  <node defType="com.stambia.json.value" id="_49GI9lpsEeujdeZP96RBZw" name="cus_company" position="4">
                    <attribute defType="com.stambia.json.value.type" id="_49GI91psEeujdeZP96RBZw" value="string"/>
                  </node>
                </node>
              </node>
            </node>
          </node>
        </node>
        <node defType="com.stambia.http.rest.responses" id="_wmQbMnV0Ee2JDeZo5hcfTw">
          <node defType="com.stambia.http.rest.response" id="_XEflN2l8Ee2Ub5oQ2PlTWg">
            <attribute defType="com.stambia.http.rest.response.code" id="_XEflOGl8Ee2Ub5oQ2PlTWg" value="200"/>
            <node defType="com.stambia.http.rest.headers" id="_XEflOWl8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.header" id="_XEflOml8Ee2Ub5oQ2PlTWg" name="Content-type"/>
            </node>
            <node defType="com.stambia.http.rest.respinfos" id="_XEflO2l8Ee2Ub5oQ2PlTWg">
              <node defType="com.stambia.http.rest.respinfo" id="_XEflPGl8Ee2Ub5oQ2PlTWg">
                <attribute defType="com.stambia.http.rest.respinfo.type" id="_XEflPWl8Ee2Ub5oQ2PlTWg" value="reasonPhrase"/>
              </node>
            </node>
          </node>
        </node>
      </node>
    </node>
  </node>
</md:node>